/*
** RIFF/WAV treating routines
**
** Writen by Sakae Tatibana <tatibana@extra.hu>
**
** 2000, 3/5 coding start
*/

#include "binary.h"

#define RIFF_WAV_C
#include "riff_wav.h"

#define WF_LEN 36

int open_wav_file(char *in, WAV_INFO *out);
int read_wav_info(FILE *in, WAV_INFO *out);
int close_wav_file(WAV_INFO *wi);

int open_wav_file(char *in, WAV_INFO *out)
{
	out->path = in;
	out->stream = fopen(in, "rb");
	if(out->stream == NULL){
		return 0;
	}

	if(read_wav_info(out->stream, out)){
		return 1;
	}else{
		fclose(out->stream);
		return 0;
	}
}

int read_wav_info(FILE *in, WAV_INFO *out)
{
	char wave_format[WF_LEN];
	short ext_head_size;
	char *ext_head;
    int n;

	out->stream = in;

	if(fread(wave_format, 1, WF_LEN, in) != WF_LEN){
		return 0;
	}

	if(memcmp(wave_format, "RIFF", 4)){
		return 0;
	}

	if(memcmp(wave_format+8, "WAVE", 4)){
		return 0;
	}

	if(memcmp(wave_format+12, "fmt ", 4)){
		return 0;
	}

    out->file_length = le_char_array_to_int32(wave_format+4) + 8;
	out->channel = le_char_array_to_int16(wave_format+22);
	out->sample_rate = le_char_array_to_int32(wave_format+24);
	out->byte_per_sec = le_char_array_to_int32(wave_format+28);
	out->block_align = le_char_array_to_int16(wave_format+32);
	out->bits_per_sample = le_char_array_to_int16(wave_format+34);

    n = le_char_array_to_int32(wave_format+16);
	if(n == 18){
		ext_head_size = 2;
    }else if (n == 16){
        ext_head_size = 0;
	}else{
		if(!read_le_int16(in, &ext_head_size)){
			return 0;
		}
	}

    while(1){
    	ext_head_size += 8;

    	ext_head = (char *)malloc(ext_head_size);

    	if(fread(ext_head, 1, ext_head_size, in) != (unsigned)ext_head_size){
    		free(ext_head);
    		return 0;
    	}

    	if(memcmp(ext_head+ext_head_size-8, "data", 4)){
    		ext_head_size = le_char_array_to_int32(ext_head+ext_head_size-4);
            free(ext_head);
    	}else{
            break;
        }
    }

	out->data_length = le_char_array_to_int32(ext_head+ext_head_size-4);

	free(ext_head);

	return 1;
}

int close_wav_file(WAV_INFO *wi)
{
	fclose(wi->stream);
	return 1;
}